<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GeneratoreEmail.php";
    include "../classi/Api.php";
    
    $geecomDb = new DbManager($costantiDatabase);
    $api      = new Api($geecomDb);

    $operazione= $geecomDb->escapeString(filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING));
    $impostazioni = recuperaImpostazioni($geecomDb);
            
    if($impostazioni["attivaApi"]!="si") {
        echo"Le api di Geecom Admin non sono state attivate";
        exit();
    }
    
    if($operazione=="creaUtente") {
        $nome      = $geecomDb->escapeString(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING));
        $cognome   = $geecomDb->escapeString(filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_STRING));
        $indirizzo = $geecomDb->escapeString(filter_input(INPUT_POST,"indirizzo",FILTER_SANITIZE_STRING));
        $citta     = $geecomDb->escapeString(filter_input(INPUT_POST,"citta",FILTER_SANITIZE_STRING));
        $telefono  = $geecomDb->escapeString(filter_input(INPUT_POST,"telefono",FILTER_SANITIZE_STRING));
        $email     = $geecomDb->escapeString(filter_input(INPUT_POST,"email",FILTER_SANITIZE_EMAIL));
        $password  = hash("sha512",filter_input(INPUT_POST,"password"));
        echo $api->aggiungiUtente($nome, $cognome, $indirizzo, $citta, $telefono, $email, $password);
        
        $datiModuloRegistrazione = $geecomDb->leggiSingolaRiga("geecAd_moduliRegistrazione", 1);
        $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);
        $generatoreEmail = new GeneratoreEmail($impostazioni["nomeMittente"], $impostazioni["emailMittente"]);
        
        $oggetto = "Creazione account";
        $link = $impostazioni['urlPiattaforma'];
        $messaggio = "Ciao $nome, <br> {$datiModuloRegistrazione["contenutoEmailRegistrazione"]}";

        if($datiModuloRegistrazione["inviaPasswordViaEmail"]=="si") {
            $messaggio .= "<br> La tua password è $passwordInChiaro";
        }
        
        $corpoMail = str_replace("___corpoTesto___",$messaggio,$datiEmail['corpoMail']);
        $html = "<!doctype html>
                <html>
                    <head>
                        <meta name=\"viewport\" content=\"width=device-width\" />
                        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                        <title>$oggetto</title>
                        <style>
                            {$datiEmail['css']}
                        </style>
                    </head>
                    <body class=\"\">
                </body>
                $corpoMail
                {$datiEmail['footerMail']}";
		      
        $htmlMail = str_replace("testo_da_inserire",$messaggio,$html);
        $generatoreEmail->invia($email, $oggetto, $htmlMail);
    }